const express = require("express");
const router = express.Router();
const wishlistController = require("../controllers/wishlistController");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");
router.use(checkApiKey);
router.use(authController.protect);

router
  .route("/")
  .get(wishlistController.getMyWishlist)
  .post(wishlistController.addToWishlist); // Expects { courseId: "..." }

router.route("/:courseId").delete(wishlistController.removeFromWishlist);

module.exports = router;
